
; *************************************************************************************************
; * sega rom template 1.4
; *************************************************************************************************
; do not modify the start and end labels
; your code will be reconstructed when compiled in the correct place





;disclaimer:
; this example has been released as a demo to showcase some functionality
; enjoy



#include	sega\s_main.mdl
#include	sega\s_math.mdl
#include	sega\s_input.mdl
#include	sega\s_dma.mdl
#include	sega\s_collision.mdl
#include	sega\s_saveram.mdl
#include	sega\s_z80.mdl

#segaromwavstart	458752	;wav files start originating
#memstart	16711680	;$ff0000

	org	512
segaromstart

	init_sega()	;get past sega security and clear ram
	init_segavdp()	;setup graphics and irq6 enabled also
	init_z80()		;setup dac



	ym_setpatch(#0,#3,#instrument0)
	ym_setpatch(#1,#3,#instrument0)
	ym_setpatch(#2,#3,#instrument0)
	ym_setpatch(#4,#3,#instrument0)
	ym_setpatch(#5,#3,#instrument0)
	ym_setpatch(#6,#3,#instrument0)

	ym_playmusic(#level1,#2,#4,#12,#15)




	createsinetable(#sinetable)


;background uses palette 0
;forground uses palette 1
;chr main uses palette 2

;new palette bg

	sega_palette(#1,#2,#2,#2)	;black
	sega_palette(#2,#4,#4,#4)	;grey
	sega_palette(#3,#6,#6,#6)	;grey
	sega_palette(#4,#7,#7,#7)	;white
	sega_palette(#5,#3,#3,#0)	;brown
	sega_palette(#6,#5,#4,#2)	;
	sega_palette(#7,#6,#5,#3)	;
	sega_palette(#8,#7,#6,#5)	;skin
	sega_palette(#9,#7,#7,#0)	;yellow
	sega_palette(#10,#7,#0,#0)	;red
	sega_palette(#11,#3,#3,#7)	;blue
	sega_palette(#12,#0,#3,#0)	;green
	sega_palette(#13,#0,#5,#0)	;
	sega_palette(#14,#3,#6,#0)	;
	sega_palette(#15,#4,#7,#0)	;




;new palette bg
	sega_palette(#17,#1,#1,#1)	;black
	sega_palette(#18,#3,#3,#3)	;grey
	sega_palette(#19,#5,#5,#5)	;grey
	sega_palette(#20,#7,#7,#7)	;white
	sega_palette(#21,#2,#2,#0)	;brown
	sega_palette(#22,#4,#3,#1)	;
	sega_palette(#23,#5,#4,#2)	;
	sega_palette(#24,#6,#5,#4)	;skin
	sega_palette(#25,#7,#7,#0)	;yellow
	sega_palette(#26,#6,#0,#0)	;red
	sega_palette(#27,#2,#2,#6)	;blue
	sega_palette(#28,#0,#2,#0)	;green
	sega_palette(#29,#0,#4,#0)	;
	sega_palette(#30,#2,#5,#0)	;
	sega_palette(#31,#3,#7,#0)	;

;new palette bg
	sega_palette(#33,#1,#1,#1)	;black
	sega_palette(#34,#3,#3,#3)	;grey
	sega_palette(#35,#5,#5,#5)	;grey
	sega_palette(#36,#7,#7,#7)	;white
	sega_palette(#37,#2,#2,#0)	;brown
	sega_palette(#38,#4,#3,#1)	;
	sega_palette(#39,#5,#4,#2)	;
	sega_palette(#40,#6,#5,#4)	;skin
	sega_palette(#41,#7,#7,#0)	;yellow
	sega_palette(#42,#6,#0,#0)	;red
	sega_palette(#43,#2,#2,#6)	;blue
	sega_palette(#44,#0,#2,#0)	;green
	sega_palette(#45,#0,#4,#0)	;
	sega_palette(#46,#2,#5,#0)	;
	sega_palette(#47,#3,#7,#0)	;
;new palette bg
	sega_palette(#49,#1,#1,#1)	;black
	sega_palette(#50,#2,#2,#2)	;grey
	sega_palette(#51,#4,#4,#4)	;grey
	sega_palette(#52,#6,#6,#6)	;white
	sega_palette(#53,#2,#2,#0)	;brown
	sega_palette(#54,#4,#3,#0)	;
	sega_palette(#55,#5,#4,#2)	;
	sega_palette(#56,#6,#5,#4)	;skin
	sega_palette(#57,#6,#6,#0)	;yellow
	sega_palette(#58,#5,#0,#0)	;red
	sega_palette(#59,#1,#1,#5)	;blue
	sega_palette(#60,#0,#1,#0)	;green
	sega_palette(#61,#0,#3,#0)	;
	sega_palette(#62,#1,#4,#0)	;
	sega_palette(#63,#2,#6,#0)	;


	device_ports()
	inputplayer1()
	inputplayer2()



	sega_font()	;setup diagnostic ascii (tiles 0-145) uses color #2 index
	sega_background(#0,#17)	;change background color like this or59



; how to disable irq 6 and re-enable it
;	move.w	#$2700,sr	; kill irq
;	move.w	#$2000,sr	; enable irq

	move.w	#0,nscreenx
	move.w	#0,screenx
	move.w	#0,screeny

	jsr	load_map	; try loading into ram





;setup player 1

	lea	entities,a0	;ok its at me now
	move.b	#1,(0,a0)	;entity number
	move.b	#200,(1,a0)	;health
	move.w	#200,(2,a0)	;xpos
	move.w	#200,(4,a0)	;ypos
	move.w	#200,(6,a0)	;old x
	move.w	#200,(8,a0)	;old y
	move.b	#0,(10,a0)	;gravity
	move.b	#0,(11,a0)	;frame cnt
	move.b	#0,(12,a0)	;frame
	move.b	#0,(13,a0)	;direction
	move.b	#1,(14,a0)	;needs update
	move.b	#0,(15,a0)	;speed
	move.w	#0,(16,a0)	;gravity
	move.b	#0,(18,a0)	;gravity cntr needs offset
	move.b	#0,(19,a0)	;i jumped
	move.b	#0,(20,a0)	;spd every 2nd frame
	move.b	#0,(21,a0)	;in water
	move.b	#0,(22,a0)	;ladder
	move.b	#0,(23,a0)	;action what anim set...etc
	move.b	#0,(24,a0)	;try to grab ladder
	move.b	#0,(25,a0)	;use item





















doloop
	add.w	#1,scrollset
	if	w,scrollset=>#2
	move.w	#0,scrollset
	endif


	move.b	#0,sprite	;should reset both sprite counters
	move.b	#40,sprite2

; get input
	device_ports()
	inputplayer1()
;	inputplayer2()


	jsr	update_elevator

; update player 1
	jsr	input_player1
;	jsr	input_player2




;scroll updater
;	if	w,scrollset=#0
	if	w,update_scroll0=#1
	jsr	update_scrollb_up
	move.w	#0,update_scroll0
	endif

	if	w,update_scroll1=#1
	jsr	update_scrollb_down
	move.w	#0,update_scroll1
	endif
;	endif

;	if	w,scrollset=#1
	if	w,update_scroll2=#1
	jsr	update_scrollb_left
	move.w	#0,update_scroll2
	endif

	if	w,update_scroll3=#1
	jsr	update_scrollb_right
	move.w	#0,update_scroll3
	endif
;	endif







; sync process
	sync()	;sync start

	jsr	linksprites

	syncend()	;sync ending




	bra	doloop



;**********************************************************************************************************************************************************************************
;**********************************************************************************************************************************************************************************


linksprites

	clr.l	d7
	move.b	sprite,d6
	clr.l	d5
	clr.l	d4
	add.b	#1,d5
getlinks
	if	b,d5!d6
	sega_linksprite(d4,d5)
	else
	sega_linksprite(d4,#40)
	bra	linksprites2
	endif

	add.b	#1,d4
	add.b	#1,d5
	bra	getlinks



;priority2

linksprites2

	clr.l	d7
	move.b	sprite2,d6
	move.l	#41,d5
	move.l	#40,d4
getlinks2
	if	b,d5!d6
	sega_linksprite(d4,d5)
	else
	sega_linksprite(d4,#0)
	rts
	endif

	add.b	#1,d4
	add.b	#1,d5
	bra	getlinks2
	rts

def	sprite	byte
def	sprite2	byte

def	scrollset	word


;**************************************************************************************************************************************************************
;**************************************************************************************************************************************************************


def	screenx	word
def	screeny	word
def	old_screenx	word
def	old_screeny	word

def	update_scroll0	word
def	update_scroll1	word
def	update_scroll2	word
def	update_scroll3	word

def	nscreenx	word

def	sinetable	long

def	word	string	16	;defined a 16 byte string space

def	cloudx	word


; make sure all data structures are even.  odd will work on emulation but crash on real hardware



level1

	incbin	'segatune2.mdm'	;3250
	even



instrument0
	dc.b	0,0,1,1,1,1,3,3,3,3,9,0,5,1,23,20,50,20,0,0,0,0,31,31,31,31,0,0,0,0,12,7,10,10,7,7,7,9,7,7,7,7,7,7,7,7,0,0,0,0,5,0,68,73,83,84,79,82,84,49,8
	even



instrument1

	dc.b	1,5,1,1,1,1,0,0,0,0,0,15,15,0,22,80,0,20,2,0,0,0,10,10,0,25,0,0,0,0,1,18,1,9,0,7,11,31,9,4,13,15,2,2,0,5,0,0,0,0,5,2,87,65,86,69,89,32,32,32,8
	even



instrument2

	dc.b	0,0,1,1,1,1,0,0,0,0,1,3,3,0,30,30,38,20,1,2,1,1,31,25,31,20,0,0,0,0,5,5,5,7,2,2,2,2,1,1,1,10,1,1,1,6,0,0,0,0,6,2,80,73,65,78,79,95,48,49,8
	even



instrument3
	dc.b	0,0,1,1,1,1,5,4,1,4,10,14,0,1,41,2,89,20,3,3,1,1,1,22,9,26,0,0,0,0,20,30,6,12,16,15,12,7,5,9,11,11,3,4,3,0,0,0,0,0,3,2,77,85,83,73,67,66,79,88,8
	even


instrument4
	dc.b	0,0,1,1,1,1,4,7,7,4,1,10,8,1,40,36,50,20,1,0,1,1,20,20,3,21,0,0,0,0,13,13,8,10,26,24,29,9,6,7,15,14,1,5,0,3,0,0,0,0,4,2,80,73,65,78,79,95,48,51,8
	even


; ***********************************************************************************************
; * code handlers
; ***********************************************************************************************
ignore_handler
	rte	; return from exception

;*************************************************************************************************
;irq 6
;*************************************************************************************************
interrupt6
;push to stack
	movem.l	a0-a6/d0-d7,-(a7)
;process things such as system clock and music player


	systemclock()	;update system clock saved as var systemclock_c 'dword'
	ym_updateplayer()

;pull from stack
	movem.l	(a7)+,a0-a6/d0-d7
	rte	; return from exception


	incbin	'jump.wav'	;2122


; included data goes here before compile automatically

segaromend	;end marker for rom size calculation






